{********************************************
; File: StdFile.p
;
;
; Copyright Apple Computer, Inc. 1986-90
; All Rights Reserved
;
********************************************}

UNIT STDFILE;

INTERFACE

USES TYPES;

CONST
{ Error Codes }
badPromptDesc = $1701;
badOrigNameDesc = $1702;
badReplyNameDesc = $1704;
badReplyPathDesc = $1705;
badCall = $1706;

{ filterProc Result Codes }
noDisplay = $0000;  { file not to be displayed }
noSelect = $0001;  { file displayed, but not selectable }
displaySelect = $0002;  { file displayed and selectable }

{ Other Constants }
sfWildAuxType = $8000;
sfMatchFileType = $8000;
sfWildFileType = $4000;
sfMatchAuxType = $4000;
sfDisplayGrey = $2000;
{$IFC UNDEFINED sfFileTypeEntriesLength }  { SFTypeList - default number of FileTypeEntries }
sfFileTypeEntriesLength = $0005;
{$SETC sfFileTypeEntriesLength := 0}
{$ENDC}

TYPE
SFReplyRecHndl = ^SFReplyRecPtr;
SFReplyRecPtr = ^SFReplyRec;
SFReplyRec = RECORD
    good : Boolean;
    fileType : Integer;
    auxFileType : Integer;
    filename : String[15];
    fullPathname : String[128];
END;

SFReplyRec2Hndl = ^SFReplyRec2Ptr;
SFReplyRec2Ptr = ^SFReplyRec2;
SFReplyRec2 = RECORD
    good : Boolean;
    fileType : Integer;
    auxType : Longint;
    nameRefDesc : RefDescriptor;
    nameRef : Ref;
    pathRefDesc : RefDescriptor;
    pathRef : Ref;
END;

MultiReplyPtr = ^MultiReplyRecord;
MultiReplyRecord = RECORD
    good : Integer;
    namesHandle : Handle;
END;

SFTypeListHndl = ^SFTypeListPtr;
SFTypeListPtr = ^SFTypeList;
SFTypeList = PACKED RECORD
    numEntries : Byte;
    fileTypeEntries : PACKED ARRAY[1..sfFileTypeEntriesLength] OF Byte;
END;

TypeSelector2 = RECORD
    flags : Integer;
    fileType : Integer;
    auxType : Longint;
END;

SFTypeList2Ptr = ^SFTypeList2;
SFTypeList2 = RECORD
    numEntries : Integer;
    fileTypeEntries : ARRAY[1..sfFileTypeEntriesLength] OF TypeSelector2;
END;

PROCEDURE SFAllCaps ( allCapsFlag:Boolean)  ;
PROCEDURE SFBootInit   ;
PROCEDURE SFGetFile ( whereX:Integer; whereY:Integer; prompt:Str255; filterProcPtr:WordProcPtr; typeListPtr:SFTypeListPtr;VAR replyPtr:SFReplyRec)  ;
PROCEDURE SFGetFile2 ( whereX:Integer; whereY:Integer; promptDesc:RefDescriptor; promptRef:Ref; filterProcPtr:WordProcPtr; typeListPtr:SFTypeList2Ptr;VAR replyPtr:SFReplyRec2)  ;
PROCEDURE SFMultiGet2 ( whereX:Integer; whereY:Integer; promptDesc:RefDescriptor; promptRef:Ref; filterProcPtr:WordProcPtr; typeListPtr:SFTypeList2Ptr;VAR replyPtr:MultiReplyPtr)  ;
PROCEDURE SFPGetFile ( whereX:Integer; whereY:Integer; prompt:Str255; filterProcPtr:WordProcPtr; typeListPtr:SFTypeListPtr; dialogTempPtr:DialogTemplate; dialogHookPtr:VoidProcPtr;VAR replyPtr:SFReplyRec)  ;
PROCEDURE SFPGetFile2 ( whereX:Integer; whereY:Integer; itemDrawPtr:ProcPtr; promptDesc:RefDescriptor; promptRef:Ref; filterProcPtr:WordProcPtr; typeListPtr:SFTypeList2Ptr; dialogTempPtr:DialogTemplate; dialogHookPtr:VoidProcPtr;VAR replyPtr:SFReplyRec2)  ;
PROCEDURE SFPMultiGet2 ( whereX:Integer; whereY:Integer; itemDrawPtr:ProcPtr; promptDesc:RefDescriptor; promptRef:Ref; filterProcPtr:WordProcPtr; typeListPtr:SFTypeList2Ptr; dialogTempPtr:DialogTemplate; dialogHookPtr:VoidProcPtr;VAR replyPtr:MultiReplyPtr)  ;
PROCEDURE SFPPutFile ( whereX:Integer; whereY:Integer; prompt:Str255; origName:Str255; maxLen:Integer; dialogTempPtr:DialogTemplate; dialogHookPtr:VoidProcPtr;VAR replyPtr:SFReplyRec)  ;
PROCEDURE SFPPutFile2 ( whereX:Integer; whereY:Integer; itemDrawPtr:ProcPtr; promptDesc:RefDescriptor; promptRef:Ref; origNameDesc:RefDescriptor; origNameRef:Ref; dialogTempPtr:DialogTemplate; dialogHookPtr:VoidProcPtr;VAR replyPtr:SFReplyRec2)  ;
PROCEDURE SFPutFile ( whereX:Integer; whereY:Integer; prompt:Str255; origName:Str255; maxLen:Integer;VAR replyPtr:SFReplyRec)  ;
PROCEDURE SFPutFile2 ( whereX:Integer; whereY:Integer; promptDesc:RefDescriptor; promptRef:Ref; origNameDesc:RefDescriptor; origNameRef:Ref;VAR replyPtr:SFReplyRec2)  ;
PROCEDURE SFReScan ( filterProcPtr:ProcPtr; typeListPtr:SFTypeList2Ptr)  ;
PROCEDURE SFReset   ;
FUNCTION SFShowInvisible ( invisibleState:Boolean) : Boolean ;
PROCEDURE SFShutDown   ;
PROCEDURE SFStartUp ( userID:Integer; dPageAddr:Integer)  ;
FUNCTION SFStatus  : Boolean ;
FUNCTION SFVersion  : Integer ;
IMPLEMENTATION
END.
